<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model 
{

    protected $table = 'notification';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function courriers()
    {
        return $this->hasMany('Courrier');
    }

    public function utilisateurs()
    {
        return $this->belongsToMany(' App\Models\Utilisateur');
    }

}